/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.sonarsource.sonarlint.core.container.connected.CloseableWsResponse;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class ModuleListDownloader {
    private final SonarLintWsClient wsClient;

    public ModuleListDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchModulesList(Path dest) {
        CloseableWsResponse response = this.wsClient.get("api/projects/index?format=json&subprojects=true");
        try (Reader contentReader = response.contentReader();){
            DefaultModule[] results = new Gson().fromJson(contentReader, DefaultModule[].class);
            Sonarlint.ModuleList.Builder moduleListBuilder = Sonarlint.ModuleList.newBuilder();
            Sonarlint.ModuleList.Module.Builder moduleBuilder = Sonarlint.ModuleList.Module.newBuilder();
            for (DefaultModule module : results) {
                moduleBuilder.clear();
                moduleListBuilder.getMutableModulesByKey().put(module.k, moduleBuilder.setKey(module.k).setName(module.nm).setQu(module.qu).build());
            }
            ProtobufUtil.writeToFile(moduleListBuilder.build(), dest.resolve("module_list.pb"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load module list", e);
        }
    }

    private static class DefaultModule {
        String k;
        String nm;
        String qu;

        private DefaultModule() {
        }
    }
}

